/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.badlogic.gdx.Gdx;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import technology.rocketjump.undermount.assets.entities.EntityAssetTypeDictionary;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetOrientation;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetType;
import technology.rocketjump.undermount.entities.model.EntityType;

@Singleton
public class RenderLayerDictionary {
    private Map<EntityType, Map<EntityAssetOrientation, Map<EntityAssetType, Integer>>> layeringMap = new EnumMap<EntityType, Map<EntityAssetOrientation, Map<EntityAssetType, Integer>>>(EntityType.class);

    @Inject
    public RenderLayerDictionary(EntityAssetTypeDictionary entityAssetTypeDictionary) throws IOException {
        this(Gdx.files.internal("assets/definitions/entityAssets/renderLayers.json").file(), entityAssetTypeDictionary);
    }

    public RenderLayerDictionary(File renderLayersFile, EntityAssetTypeDictionary entityAssetTypeDictionary) throws IOException {
        JSONObject renderLayersJson = JSON.parseObject(FileUtils.readFileToString(renderLayersFile, "UTF-8"));
        for (String typeString : renderLayersJson.keySet()) {
            JSONObject orderingContainer;
            EntityAssetOrientation orientationValue;
            if (typeString.startsWith("_")) continue;
            EnumMap typeToOrientationMap = new EnumMap(EntityAssetOrientation.class);
            JSONObject orientationJson = renderLayersJson.getJSONObject(typeString);
            for (String orientationString : orientationJson.keySet()) {
                orientationValue = EntityAssetOrientation.valueOf(orientationString);
                orderingContainer = orientationJson.getJSONObject(orientationString);
                if (!orderingContainer.containsKey("ordering")) continue;
                JSONArray orderingArray = orderingContainer.getJSONArray("ordering");
                LinkedHashMap<EntityAssetType, Integer> layerMap = new LinkedHashMap<EntityAssetType, Integer>();
                for (int layerCounter = 0; layerCounter < orderingArray.size(); ++layerCounter) {
                    layerMap.put(entityAssetTypeDictionary.getByName(orderingArray.getString(layerCounter)), layerCounter);
                }
                typeToOrientationMap.put(orientationValue, layerMap);
            }
            for (String orientationString : orientationJson.keySet()) {
                orientationValue = EntityAssetOrientation.valueOf(orientationString);
                orderingContainer = orientationJson.getJSONObject(orientationString);
                if (!orderingContainer.containsKey("sameAs")) continue;
                EntityAssetOrientation sameAs = EntityAssetOrientation.valueOf(orderingContainer.getString("sameAs"));
                typeToOrientationMap.put(orientationValue, typeToOrientationMap.get((Object)sameAs));
            }
            this.layeringMap.put(EntityType.valueOf(typeString), typeToOrientationMap);
        }
    }

    public int getRenderingLayer(EntityType entityType, EntityAssetOrientation orientation, EntityAssetType assetType) {
        Map<EntityAssetOrientation, Map<EntityAssetType, Integer>> orientationToAssetTypeMap = this.layeringMap.get((Object)entityType);
        if (orientationToAssetTypeMap == null) {
            System.err.println("Could not find layering information for entity type: " + entityType.toString() + " in " + this.getClass().getSimpleName());
            return -3;
        }
        Map<EntityAssetType, Integer> assetTypeToLayerMap = orientationToAssetTypeMap.get((Object)orientation);
        if (assetTypeToLayerMap == null) {
            System.err.println("Could not find layering information for orientation " + (Object)((Object)orientation) + " for entity type " + (Object)((Object)entityType) + " in " + this.getClass().getSimpleName());
            return -2;
        }
        Integer layerValue = assetTypeToLayerMap.get(assetType);
        if (layerValue == null) {
            System.err.println("Could not find layer information for asset type " + assetType + " facing " + (Object)((Object)orientation) + " for entity type " + (Object)((Object)entityType) + " in " + this.getClass().getSimpleName());
            return -1;
        }
        return layerValue;
    }
}

